puts {# 2008 December 11
#
# The author disclaims copyright to this source code.  In place of
# a legal notice, here is a blessing:
#
#    May you do good and not evil.
#    May you find forgiveness for yourself and forgive others.
#    May you share freely, never taking more than you give.
#
#***********************************************************************
# This file implements regression tests for SQLite library.
#
# This file is automatically generated from a separate TCL script.
# This file seeks to exercise integer boundary values.
#
# $Id: boundary4.tcl,v 1.3 2009/01/02 15:45:48 shane Exp $

set testdir [file dirname $argv0]
source $testdir/tester.tcl

# Many of the boundary tests depend on a working 64-bit implementation.
if {![working_64bit_int]} { finish_test; return }
ifcapable !altertable     { finish_test; return }
}

expr srand(0)

# Generate interesting boundary numbers
#
foreach x {
  0x7f
  0x7fff
  0x7fffff
  0x7fffffff
  0x7fffffffff
  0x7fffffffffff
  0x7fffffffffffff
  0x7fffffffffffffff
} {
  set x [expr {wide($x)}]
  set boundarynum($x) 1
  set boundarynum([expr {$x+1}]) 1
  set boundarynum([expr {-($x+1)}]) 1
  set boundarynum([expr {-($x+2)}]) 1
  set boundarynum([expr {$x+$x+1}]) 1
  set boundarynum([expr {$x+$x+2}]) 1
}
set x [expr {wide(127)}]
for {set i 127} {$i<=9} {incr i} {
  set boundarynum($x) 1
  set boundarynum([expr {$x+1}]) 1
  set x [expr {wide($x*128 + 127)}]
}

# Scramble the $inlist into a random order.
#
proc scramble {inlist} {
  set y {}
  foreach x $inlist {
    lappend y [list [expr {rand()}] $x]
  }
  set y [lsort $y]
  set outlist {}
  foreach x $y {
    lappend outlist [lindex $x 1]
  }
  return $outlist
}

# A simple selection sort.  Not trying to be efficient.
#
proc sort {inlist} {
  set outlist {}
  set mn [lindex $inlist 0]
  foreach x $inlist {
    if {$x<$mn} {set mn $x}
  }
  set outlist $mn
  set mx $mn
  while {1} {
    set valid 0
    foreach x $inlist {
      if {$x>$mx && (!$valid || $mn>$x)} {
        set mn $x
        set valid 1
      }
    }
    if {!$valid} break
    lappend outlist $mn
    set mx $mn
  }
  return $outlist
}

# Reverse the order of a list
#
proc reverse {inlist} {
  set i [llength $inlist]
  set outlist {}
  for {incr i -1} {$i>=0} {incr i -1} {
    lappend outlist [lindex $inlist $i]
  }
  return $outlist
}

set nums1 [scramble [array names boundarynum]]
set nums2 [scramble [array names boundarynum]]

set tname boundary4
puts "do_test $tname-1.1 \173"
puts "  db eval \173"
puts "    CREATE TABLE t1(a,x);"
set a 0
set all_rowid {}
set all_a {}
set all_x {}
foreach r $nums1 {
  incr a
  set t1ra($r) $a
  set t1ar($a) $r
  set x [format %08x%08x [expr {wide($r)>>32}] $r]
  set t1rx($r) $x
  set t1xr($x) $r
  puts "    INSERT INTO t1(oid,a,x) VALUES($r,$a,'$x');"
  lappend all_rowid $r
  lappend all_a $a
  lappend all_x $x
}
puts "    CREATE INDEX t1i1 ON t1(a);"
puts "    CREATE INDEX t1i2 ON t1(x);"
puts "  \175"
puts "\175 {}"

puts "do_test $tname-1.2 \173"
puts "  db eval \173"
puts "    SELECT count(*) FROM t1"
puts "  \175"
puts "\175 {[llength $nums1]}"

proc maketest {tnum sql answer} {
  puts "do_test $::tname-$tnum \173"
  puts "  db eval \173"
  puts "    $sql"
  puts "  \175"
  puts "\175 {$answer}"
}

set ans {}
foreach r [sort $all_rowid] {
  lappend ans $r $t1ra($r) $t1rx($r)
}
maketest 1.3 {SELECT rowid, a, x FROM t1 ORDER BY +rowid} $ans
maketest 1.4 {SELECT rowid, a, x FROM t1 ORDER BY rowid} $ans

set ans {}
foreach r [reverse [sort $all_rowid]] {
  lappend ans $r $t1ra($r) $t1rx($r)
}
maketest 1.5 {SELECT rowid, a, x FROM t1 ORDER BY +rowid DESC} $ans
maketest 1.6 {SELECT rowid, a, x FROM t1 ORDER BY rowid DESC} $ans

set ans {}
foreach a [sort $all_a] {
  set r $t1ar($a)
  lappend ans $r $a $t1rx($r)
}
maketest 1.7 {SELECT rowid, a, x FROM t1 ORDER BY +a} $ans
maketest 1.8 {SELECT rowid, a, x FROM t1 ORDER BY a} $ans

set ans {}
foreach a [reverse [sort $all_a]] {
  set r $t1ar($a)
  lappend ans $r $a $t1rx($r)
}
maketest 1.9 {SELECT rowid, a, x FROM t1 ORDER BY +a DESC} $ans
maketest 1.10 {SELECT rowid, a, x FROM t1 ORDER BY a DESC} $ans

set ans {}
foreach x [sort $all_x] {
  set r $t1xr($x)
  lappend ans $r $t1ra($r) $x
}
maketest 1.11 {SELECT rowid, a, x FROM t1 ORDER BY +x} $ans
maketest 1.12 {SELECT rowid, a, x FROM t1 ORDER BY x} $ans

set ans {}
foreach x [reverse [sort $all_x]] {
  set r $t1xr($x)
  lappend ans $r $t1ra($r) $x
}
maketest 1.13 {SELECT rowid, a, x FROM t1 ORDER BY +x DESC} $ans
maketest 1.14 {SELECT rowid, a, x FROM t1 ORDER BY x DESC} $ans

maketest 2.1 {UPDATE t1 SET rowid=a, a=rowid} {}

set ans {}
foreach r [sort $all_rowid] {
  lappend ans $r $t1ra($r) $t1rx($r)
}
maketest 2.3 {SELECT a, rowid, x FROM t1 ORDER BY +a} $ans
maketest 2.4 {SELECT a, rowid, x FROM t1 ORDER BY a} $ans

set ans {}
foreach r [reverse [sort $all_rowid]] {
  lappend ans $r $t1ra($r) $t1rx($r)
}
maketest 2.5 {SELECT a, rowid, x FROM t1 ORDER BY +a DESC} $ans
maketest 2.6 {SELECT a, rowid, x FROM t1 ORDER BY a DESC} $ans

set ans {}
foreach a [sort $all_a] {
  set r $t1ar($a)
  lappend ans $r $a $t1rx($r)
}
maketest 2.7 {SELECT a, rowid, x FROM t1 ORDER BY +rowid} $ans
maketest 2.8 {SELECT a, rowid, x FROM t1 ORDER BY rowid} $ans

set ans {}
foreach a [reverse [sort $all_a]] {
  set r $t1ar($a)
  lappend ans $r $a $t1rx($r)
}
maketest 2.9 {SELECT a, rowid, x FROM t1 ORDER BY +rowid DESC} $ans
maketest 2.10 {SELECT a, rowid, x FROM t1 ORDER BY rowid DESC} $ans

set ans {}
foreach x [sort $all_x] {
  set r $t1xr($x)
  lappend ans $r $t1ra($r) $x
}
maketest 2.11 {SELECT a, rowid, x FROM t1 ORDER BY +x} $ans
maketest 2.12 {SELECT a, rowid, x FROM t1 ORDER BY x} $ans

set ans {}
foreach x [reverse [sort $all_x]] {
  set r $t1xr($x)
  lappend ans $r $t1ra($r) $x
}
maketest 2.13 {SELECT a, rowid, x FROM t1 ORDER BY +x DESC} $ans
maketest 2.14 {SELECT a, rowid, x FROM t1 ORDER BY x DESC} $ans

maketest 3.1 {UPDATE t1 SET rowid=a, a=rowid} {}
maketest 3.2 {ALTER TABLE t1 ADD COLUMN z; UPDATE t1 SET z=zeroblob(600)} {}

set ans {}
foreach r [sort $all_rowid] {
  lappend ans $r $t1ra($r) $t1rx($r)
}
maketest 3.3 {SELECT rowid, a, x FROM t1 ORDER BY +rowid} $ans
maketest 3.4 {SELECT rowid, a, x FROM t1 ORDER BY rowid} $ans

set ans {}
foreach r [reverse [sort $all_rowid]] {
  lappend ans $r $t1ra($r) $t1rx($r)
}
maketest 3.5 {SELECT rowid, a, x FROM t1 ORDER BY +rowid DESC} $ans
maketest 3.6 {SELECT rowid, a, x FROM t1 ORDER BY rowid DESC} $ans

set ans {}
foreach a [sort $all_a] {
  set r $t1ar($a)
  lappend ans $r $a $t1rx($r)
}
maketest 3.7 {SELECT rowid, a, x FROM t1 ORDER BY +a} $ans
maketest 3.8 {SELECT rowid, a, x FROM t1 ORDER BY a} $ans

set ans {}
foreach a [reverse [sort $all_a]] {
  set r $t1ar($a)
  lappend ans $r $a $t1rx($r)
}
maketest 3.9 {SELECT rowid, a, x FROM t1 ORDER BY +a DESC} $ans
maketest 3.10 {SELECT rowid, a, x FROM t1 ORDER BY a DESC} $ans

set ans {}
foreach x [sort $all_x] {
  set r $t1xr($x)
  lappend ans $r $t1ra($r) $x
}
maketest 3.11 {SELECT rowid, a, x FROM t1 ORDER BY +x} $ans
maketest 3.12 {SELECT rowid, a, x FROM t1 ORDER BY x} $ans

set ans {}
foreach x [reverse [sort $all_x]] {
  set r $t1xr($x)
  lappend ans $r $t1ra($r) $x
}
maketest 3.13 {SELECT rowid, a, x FROM t1 ORDER BY +x DESC} $ans
maketest 3.14 {SELECT rowid, a, x FROM t1 ORDER BY x DESC} $ans


maketest 4.1 {UPDATE t1 SET rowid=a, a=rowid, x=z, z=x} {}

set ans {}
foreach r [sort $all_rowid] {
  lappend ans $r $t1ra($r) $t1rx($r)
}
maketest 4.3 {SELECT a, rowid, z FROM t1 ORDER BY +a} $ans
maketest 4.4 {SELECT a, rowid, z FROM t1 ORDER BY a} $ans

set ans {}
foreach r [reverse [sort $all_rowid]] {
  lappend ans $r $t1ra($r) $t1rx($r)
}
maketest 4.5 {SELECT a, rowid, z FROM t1 ORDER BY +a DESC} $ans
maketest 4.6 {SELECT a, rowid, z FROM t1 ORDER BY a DESC} $ans

set ans {}
foreach a [sort $all_a] {
  set r $t1ar($a)
  lappend ans $r $a $t1rx($r)
}
maketest 4.7 {SELECT a, rowid, z FROM t1 ORDER BY +rowid} $ans
maketest 4.8 {SELECT a, rowid, z FROM t1 ORDER BY rowid} $ans

set ans {}
foreach a [reverse [sort $all_a]] {
  set r $t1ar($a)
  lappend ans $r $a $t1rx($r)
}
maketest 4.9 {SELECT a, rowid, z FROM t1 ORDER BY +rowid DESC} $ans
maketest 4.10 {SELECT a, rowid, z FROM t1 ORDER BY rowid DESC} $ans

set ans {}
foreach x [sort $all_x] {
  set r $t1xr($x)
  lappend ans $r $t1ra($r) $x
}
maketest 4.11 {SELECT a, rowid, z FROM t1 ORDER BY +z} $ans
maketest 4.12 {SELECT a, rowid, z FROM t1 ORDER BY z} $ans

set ans {}
foreach x [reverse [sort $all_x]] {
  set r $t1xr($x)
  lappend ans $r $t1ra($r) $x
}
maketest 4.13 {SELECT a, rowid, z FROM t1 ORDER BY +z DESC} $ans
maketest 4.14 {SELECT a, rowid, z FROM t1 ORDER BY z DESC} $ans

puts {finish_test}
