# Bundler Contributor Guidelines

Thank you for your interest in making Bundler better! We welcome contributions from everyone. Dozens of contributors like you have submitted feature improvements, fixed bugs, and written new documentation. [Join the Bundler Slack community](https://slack.bundler.io/) to connect with the Bundler core team and other contributors like you.

Before submitting a contribution, read through the following guidelines:

* [Bundler Code of Conduct](https://github.com/rubygems/rubygems/blob/master/CODE_OF_CONDUCT.md) (By participating in Bundler, you agree to abide by the terms laid out in the CoC.)
* [Pull Request Guidelines](../development/PULL_REQUESTS.md)

And be sure to [set up your development environment](../development/SETUP.md).

## Feature Requests

To request substantial changes to Bundler and/or Bundler documentation, please refer to the [README](https://github.com/rubygems/rfcs/blob/master/README.md) in the [RFC repository](https://github.com/rubygems/rfcs) for instructions.

## Contributing to Bundler

Here are the different ways you can start contributing to the Bundler project:

* [First contribution suggestions](HOW_YOU_CAN_HELP.md)
* [Adding new features](../development/NEW_FEATURES.md)
* [Triaging bugs](BUG_TRIAGE.md)
* [Writing documentation](../documentation/WRITING.md)
* [Community engagement](COMMUNITY.md)

## Supporting Bundler

RubyGems is managed by [Ruby Central](https://rubycentral.org), a non-profit organization that supports the Ruby community through projects like this one, as well as [RubyConf](https://rubyconf.org), [RailsConf](https://railsconf.org), and [RubyGems.org](https://rubygems.org). You can support Ruby Central by attending or [sponsoring](sponsors@rubycentral.org) a conference, or by [joining as a supporting member](https://rubycentral.org/#/portal/signup).
