/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-string-utils.h
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Alexandre Abreu <alexandre.abreu@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

#include <glib.h>

#include "unity-webapps-string-utils.h"

gchar *
unity_webapps_string_utils_canonicalize_string (const gchar *str, gboolean keep_whitespaces)
{
  gchar *it;
  GString *res = g_string_sized_new (g_utf8_strlen (str, -1));

  for (it = (gchar*)str; *it; it = g_utf8_next_char (it))
    {
      gunichar chr = g_utf8_get_char (it);
      if (g_unichar_isalnum (chr) || (g_unichar_isspace (chr) && keep_whitespaces))
		  res = g_string_append_unichar (res, chr);
    }
  return g_string_free (res, FALSE);
}

