/*
 * Decompiled with CFR 0.152.
 */
package com.github.andrewoma.dexx.collection;

import com.github.andrewoma.dexx.collection.Builder;
import com.github.andrewoma.dexx.collection.BuilderFactory;
import com.github.andrewoma.dexx.collection.Function;
import com.github.andrewoma.dexx.collection.Iterable;
import com.github.andrewoma.dexx.collection.KeyFunction;
import com.github.andrewoma.dexx.collection.Pair;
import com.github.andrewoma.dexx.collection.SortedMap;
import com.github.andrewoma.dexx.collection.internal.base.AbstractIterable;
import com.github.andrewoma.dexx.collection.internal.base.AbstractSortedMap;
import com.github.andrewoma.dexx.collection.internal.builder.AbstractSelfBuilder;
import com.github.andrewoma.dexx.collection.internal.redblack.DefaultTreeFactory;
import com.github.andrewoma.dexx.collection.internal.redblack.DerivedKeyFactory;
import com.github.andrewoma.dexx.collection.internal.redblack.RedBlackTree;
import com.github.andrewoma.dexx.collection.internal.redblack.Tree;
import com.github.andrewoma.dexx.collection.internal.redblack.TreeFactory;
import java.util.Comparator;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeMap<K, V>
extends AbstractSortedMap<K, V> {
    private final Tree<K, V> tree;
    private final RedBlackTree<K, V> redBlackTree;

    public TreeMap() {
        this.tree = null;
        this.redBlackTree = new RedBlackTree();
    }

    @NotNull
    public static <K, V> BuilderFactory<Pair<K, V>, TreeMap<K, V>> factory(final Comparator<? super K> ordering, final KeyFunction<K, V> keyFunction) {
        return new BuilderFactory<Pair<K, V>, TreeMap<K, V>>(){

            @Override
            @NotNull
            public Builder<Pair<K, V>, TreeMap<K, V>> newBuilder() {
                return new AbstractSelfBuilder<Pair<K, V>, TreeMap<K, V>>(new TreeMap(ordering, keyFunction)){

                    @Override
                    @NotNull
                    public Builder<Pair<K, V>, TreeMap<K, V>> add(Pair<K, V> element) {
                        this.result = ((TreeMap)this.result).put(element.component1(), element.component2());
                        return this;
                    }
                };
            }
        };
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.redBlackTree.getOrdering();
    }

    public TreeMap(Comparator<? super K> ordering, KeyFunction<K, V> keyFunction) {
        TreeFactory factory = keyFunction == null ? new DefaultTreeFactory() : new DerivedKeyFactory();
        this.tree = null;
        this.redBlackTree = new RedBlackTree<K, V>(factory, ordering, keyFunction);
    }

    private TreeMap(Tree<K, V> tree, RedBlackTree<K, V> redBlackTree) {
        this.tree = tree;
        this.redBlackTree = redBlackTree;
    }

    @Override
    public boolean containsKey(@NotNull K key) {
        return this.redBlackTree.contains(this.tree, key);
    }

    @Override
    @NotNull
    public TreeMap<K, V> put(@NotNull K key, V value) {
        return new TreeMap<K, V>(this.redBlackTree.update(this.tree, key, value, true), this.redBlackTree);
    }

    @Override
    public V get(@NotNull K key) {
        return this.redBlackTree.get(this.tree, key);
    }

    @Override
    public int size() {
        return RedBlackTree.count(this.tree);
    }

    @Override
    public boolean isEmpty() {
        return this.redBlackTree.isEmpty(this.tree);
    }

    @Override
    @NotNull
    public TreeMap<K, V> remove(@NotNull K key) {
        return new TreeMap<K, V>(this.redBlackTree.delete(this.tree, key), this.redBlackTree);
    }

    @Override
    @NotNull
    public Iterator<Pair<K, V>> iterator() {
        return this.redBlackTree.iterator(this.tree);
    }

    @Override
    public <U> void forEach(@NotNull Function<Pair<K, V>, U> f) {
        this.redBlackTree.forEach(this.tree, f);
    }

    @Override
    @Nullable
    public Pair<K, V> first() {
        return this.tree != null ? this.toPair(this.redBlackTree.smallest(this.tree)) : null;
    }

    private Pair<K, V> toPair(Tree<K, V> tree) {
        return new Pair<K, V>(tree.getKey(this.redBlackTree.getKeyFunction()), tree.getValue());
    }

    @Override
    @Nullable
    public Pair<K, V> last() {
        return this.tree != null ? this.toPair(this.redBlackTree.greatest(this.tree)) : null;
    }

    @Override
    @NotNull
    public SortedMap<K, V> drop(int number) {
        return new TreeMap<K, V>(this.redBlackTree.drop(this.tree, number), this.redBlackTree);
    }

    @Override
    @NotNull
    public SortedMap<K, V> take(int number) {
        return new TreeMap<K, V>(this.redBlackTree.take(this.tree, number), this.redBlackTree);
    }

    @Override
    @NotNull
    public SortedMap<K, V> from(@NotNull K key, boolean inclusive) {
        return new TreeMap<K, V>(this.redBlackTree.from(this.tree, key, inclusive), this.redBlackTree);
    }

    @Override
    @NotNull
    public SortedMap<K, V> to(@NotNull K key, boolean inclusive) {
        return new TreeMap<K, V>(this.redBlackTree.until(this.tree, key, inclusive), this.redBlackTree);
    }

    @Override
    @NotNull
    public SortedMap<K, V> range(@NotNull K from, boolean fromInclusive, @NotNull K to, boolean toInclusive) {
        return new TreeMap<K, V>(this.redBlackTree.range(this.tree, from, fromInclusive, to, toInclusive), this.redBlackTree);
    }

    @Override
    @NotNull
    public Iterable<K> keys() {
        return new AbstractIterable<K>(){

            @Override
            @NotNull
            public Iterator<K> iterator() {
                return TreeMap.this.redBlackTree.keysIterator(TreeMap.this.tree);
            }
        };
    }

    @Override
    @NotNull
    public Iterable<V> values() {
        return new AbstractIterable<V>(){

            @Override
            @NotNull
            public Iterator<V> iterator() {
                return TreeMap.this.redBlackTree.valuesIterator(TreeMap.this.tree);
            }
        };
    }

    @NotNull
    protected TreeMap<K, V> slice(int from, int until) {
        return new TreeMap<K, V>(this.redBlackTree.slice(this.tree, from, until), this.redBlackTree);
    }
}

