#!/bin/sh

dbc_dbname="testdbname"
dbc_dbuser="testdbuser"
dbc_dbadmin="testadmin"
dbc_dbpass="testdbpass"
dbc_dbadmpass="testadmpass"
dbc_dbserver="testserver"
dbc_dbport="testport"

# get some common functions
. `dirname "$0"`/functions
. ${_dbc_root}/internal/pgsql

# make sure the correct local username is used for all variations
test__dbc_psql_local_username(){
  local _dbc_asuser dbc_authmethod_user dbc_authmethod_admin dbc_dbserver
  local output stderr dbc_dbuser

  dbc_dbuser=""

  log_tc "_dbc_asuser='' dbc_authmethod_admin='' dbc_dbserver=''"
  output=$(_dbc_psql_local_username)
  assertTrue "_dbc_psql_local_username failed" $?
  assertEquals "root" "$output"

  log_tc "_dbc_asuser='' dbc_authmethod_admin='password' dbc_dbserver=''"
  dbc_authmethod_admin="password"
  output=$(_dbc_psql_local_username)
  assertTrue "_dbc_psql_local_username failed" $?
  assertEquals "root" "$output"

  log_tc "_dbc_asuser='' dbc_authmethod_admin='ident' dbc_dbserver=''"
  dbc_dbserver=""
  dbc_authmethod_admin="ident"
  output=$(_dbc_psql_local_username)
  assertTrue "_dbc_psql_local_username failed" $?
  assertEquals "$dbc_dbadmin" "$output"

  log_tc "_dbc_asuser='yes' dbc_dbuser='' dbc_authmethod_user='ident' dbc_dbserver=''"
  _dbc_asuser="yes"
  dbc_authmethod_user="ident"
  dbc_dbserver=""
  output=$(_dbc_psql_local_username 2>/dev/null)
  stderr=$(_dbc_psql_local_username 2>&1 >/dev/null)
  assertTrue "_dbc_psql_local_username failed" $?
  assertEquals "root" "$output"
  assertEquals "warning: ident method specified but local account doesn't exist." "$stderr"

  dbc_dbuser=$(id -un)
  log_tc "_dbc_asuser='yes' dbc_dbuser='$dbc_dbuser' dbc_authmethod_user='ident' dbc_dbserver=''"
  _dbc_asuser="yes"
  dbc_authmethod_user="ident"
  dbc_dbserver=""
  output=$(_dbc_psql_local_username)
  assertTrue "_dbc_psql_local_username failed" $?
  assertEquals "$dbc_dbuser" "$output"

  log_tc "_dbc_asuser='yes' dbc_dbuser='' dbc_authmethod_user='password' dbc_dbserver=''"
  dbc_dbuser=""
  _dbc_asuser="yes"
  dbc_authmethod_user="password"
  dbc_dbserver=""
  output=$(_dbc_psql_local_username)
  assertTrue "_dbc_psql_local_username failed" $?
  assertEquals "root" "$output"
}

test__dbc_psql_remote_username(){
  local output _dbc_asuser

  log_tc "_dbc_asuser=''"
  output=$(_dbc_psql_remote_username)
  assertTrue "_dbc_psql_remote_username failed" $?
  assertEquals "$dbc_dbadmin" "$output"

  log_tc "_dbc_asuser='yes'"
  _dbc_asuser="yes"
  output=$(_dbc_psql_remote_username)
  assertTrue "_dbc_psql_remote_username failed" $?
  assertEquals "$dbc_dbuser" "$output"
}

test_dbc_pgsql_createdb(){
  local output

  log_tc "checkconnect fails"
  mockup -r 1 _dbc_pgsql_check_connect
  dbc_pgsql_createdb
  assertFalse "dbc_pgsql_createdb (checkconnect) should have failed" $?

  log_tc "database already exists"
  mockup _dbc_pgsql_check_connect
  mockup _dbc_pgsql_check_database
  output=`dbc_pgsql_createdb 2>&1`
  assertTrue "dbc_pgsql_createdb (exists) failed" $?
  assertEquals "creating database testdbname: already exists." "$output"

  log_tc "database does not exist, creation successful"
  cat </dev/null > "$_dbc_logfile"
  mockup _dbc_pgsql_check_connect
  mockup -r 1 _dbc_pgsql_check_database
  mockup _dbc_createdb
  mockup _dbc_pgsql_check_database
  dbc_pgsql_createdb >/dev/null 2>&1
  assertTrue "dbc_pgsql_createdb failed" $?
  assertFilesEqual "./data/dbc_pgsql_createdb.verifyok.txt" "$_dbc_logfile"

  log_tc "database does not exist, creation failed"
  cat </dev/null > "$_dbc_logfile"
  mockup _dbc_pgsql_check_connect
  mockup -r 1 _dbc_pgsql_check_database
  mockup -r 1 _dbc_createdb
  output=`dbc_pgsql_createdb 2>&1`
  assertFalse "dbc_pgsql_createdb should have failed" $?
  assertEquals "creating database testdbname: failed." "$output"

  log_tc "database does not exist, creation ok, verify failed"
  mockup _dbc_pgsql_check_connect
  mockup -r 1 _dbc_pgsql_check_database
  mockup _dbc_createdb
  mockup -r 1 _dbc_pgsql_check_database
  cat </dev/null > "$_dbc_logfile"
  dbc_pgsql_createdb >/dev/null 2>&1
  assertFalse "dbc_pgsql_createdb should have failed" $?
  assertFilesEqual "./data/dbc_pgsql_createdb.verifyfail.txt" "$_dbc_logfile"
}

test_dbc_pgsql_createdb__with_encoding(){
  . ${_dbc_root}/internal/pgsql
  local dbsqlfile dbargsfile dbc_pgsql_createdb_encoding
  log_tc "encoding not specified"
  mockup _dbc_pgsql_check_connect
  mockup -r 1 _dbc_pgsql_check_database
  mockup -i _dbc_psql
  dbargsfile="$mockup_cmdline"
  dbsqlfile="$mockup_inputfile"
  mockup _dbc_pgsql_check_database
  dbc_pgsql_createdb >/dev/null 2>&1
  assertTrue "dbc_pgsql_createdb failed" $?
  assertFilesEqual "_dbc_createdb without encoding" "./data/dbc_pgsql_createdb.psql.noencoding.cmdline" "$dbargsfile"
  assertFilesEqual "_dbc_createdb input without encoding" "./data/dbc_pgsql_createdb.psql.noencoding.sql" "$dbsqlfile"

  log_tc "encoding specified"
  dbc_pgsql_createdb_encoding="UTF-8"
  mockup _dbc_pgsql_check_connect
  mockup -r 1 _dbc_pgsql_check_database
  mockup -i _dbc_psql
  dbargsfile="$mockup_cmdline"
  dbsqlfile="$mockup_inputfile"
  mockup _dbc_pgsql_check_database
  dbc_pgsql_createdb >/dev/null 2>&1
  assertTrue "dbc_pgsql_createdb failed" $?
  assertFilesEqual "_dbc_createdb with encoding" "./data/dbc_pgsql_createdb.psql.encoding.cmdline" "$dbargsfile"
  assertFilesEqual "_dbc_createdb input with encoding" "./data/dbc_pgsql_createdb.psql.encoding.sql" "$dbsqlfile"
}

. /usr/share/shunit2/shunit2
